<?php

/**
 * ======================================================================
 * LICENSE: This file is subject to the terms and conditions defined in *
 * file 'license.txt', which is part of this source code package.       *
 * ======================================================================
 */

/**
 * AAM core policy resources
 *
 * @package AAM
 *
 * @since 6.8.3 https://github.com/aamplugin/advanced-access-manager/issues/207
 * @since 6.0.0 Initial implementation of the class
 *
 * @version 6.8.3
 */
class AAM_Core_Policy_Resource
{

    /**
     * Backend Menu resource
     *
     * @version 6.0.0
     */
    const MENU = 'BackendMenu';

    /**
     * Top admin bar resource
     *
     * @version 6.0.0
     */
    const TOOLBAR = 'Toolbar';

    /**
     * Backend & Frontend widget resource
     *
     * @version 6.0.0
     */
    const WIDGET = 'Widget';

    /**
     * Backend metabox resource
     *
     * @version 6.0.0
     */
    const METABOX = 'Metabox';

    /**
     * Capability resource
     *
     * @version 6.0.0
     */
    const CAPABILITY = 'Capability';

    /**
     * Role resource
     *
     * @version 6.0.0
     */
    const ROLE = 'Role';

    /**
     * Post resource
     *
     * @version 6.0.0
     */
    const POST = 'Post';

    /**
     * Uri resource
     *
     * @version 6.0.0
     */
    const URI = "URI";

    /**
     * Plugin resource
     *
     * @version 6.0.0
     */
    const PLUGIN = 'Plugin';

    /**
     * API Route resource
     *
     * @version 6.0.0
     */
    const ROUTE = 'Route';

    /**
     * WordPress core hooks (actions and filters)
     *
     * @version 6.8.3
     */
    const HOOK = 'Hook';

}