<?php
 
 
add_action( 'wp_enqueue_scripts', 'hubspot_blog_theme_enqueue_styles' );
 
 
function hubspot_blog_theme_enqueue_styles() {
 
 
wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
 
 
}

/* Dynamic Button for Simple & Variable Product */
 
function wpamit_add_buy_now_button_single()
{
    global $product;
    printf( '<button id="wpamit-adding-button" type="submit" name="wpamit-buy-now" value="%d" class="single_add_to_cart_button buy_now_button button alt">%s</button>', $product->get_ID(), esc_html__( 'Buy Now', 'wpamit' ) );
}
 
add_action( 'woocommerce_after_add_to_cart_button', 'wpamit_add_buy_now_button_single' );
 
 
function wpamit_handle_buy_now()
{
    if ( !isset( $_REQUEST['wpamit-buy-now'] ) )
    {
        return false;
    }
 
    WC()->cart->empty_cart();
 
    $product_id = absint( $_REQUEST['wpamit-buy-now'] );
    $quantity = absint( $_REQUEST['quantity'] );
 
    if ( isset( $_REQUEST['variation_id'] ) ) {
 
        $variation_id = absint( $_REQUEST['variation_id'] );
        WC()->cart->add_to_cart( $product_id, 1, $variation_id );
 
    }else{
        WC()->cart->add_to_cart( $product_id, $quantity );
    }
 
    wp_safe_redirect( wc_get_checkout_url() );
    exit;
}
 
add_action( 'wp_loaded', 'wpamit_handle_buy_now' );

// change add to cart button text on single product page
add_filter( 'woocommerce_product_single_add_to_cart_text', 'wpamit_change_single_add_to_cart_text' ); 
function wpamit_change_single_add_to_cart_text() {
    return __( 'Select Design', 'woocommerce' ); 
}

// change add to cart button text on shop page and product archives page
add_filter( 'woocommerce_product_add_to_cart_text', 'wpamit_change_archive_add_to_cart_text' );  
function wpamit_change_archive_add_to_cart_text() {
    return __( 'Select Design', 'woocommerce' );
}
// Product Images @ Woo Checkout Page
add_filter( 'woocommerce_cart_item_name', 'wpamit_product_image_at_checkout', 9999, 3 );
   
function wpamit_product_image_at_checkout( $name, $cart_item, $cart_item_key ) {
    if ( ! is_checkout() ) return $name;
    $product = $cart_item['data'];
    $thumbnail = $product->get_image( array( '50', '50' ), array( 'class' => 'alignleft' ) );
    return $thumbnail . $name;
}
//remove wordpress version number
function wpamit_remove_version() {
return '';
}
add_filter('the_generator', 'wpamit_remove_version');

//change wordpress login page logo using snippet of code
add_action( 'login_enqueue_scripts', 'wpuruweb_login_logo_change' );
 
function wpuruweb_login_logo_change() {
   ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
           background-image: url(wp-content/uploads/2023/09/Categories.jpg);
           height: 100px;
           width: 100px;
           background-size: contain;
           background-repeat: no-repeat;
           background-color: transparent;
      }
    </style>
   <?php
}

// Add Social Media Sharing Icons in wordpress and woocommerce
function enqueue_font_awesome() {
    echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">';
}
add_action('wp_head', 'enqueue_font_awesome');
add_action('admin_head', 'enqueue_font_awesome');

function wpamit_add_social_sharing_buttons($content) {
    $enable_mobile_sharing = get_option('enable_mobile_sharing', true);
    $is_mobile = wp_is_mobile();

    if ($is_mobile) {
        $placement = get_option('social_sharing_placement_mobile', 'sticky_bottom_right');
        $icon_size = get_option('mobile_icon_size', '30');
    } else {
        $placement = get_option('social_sharing_placement_desktop', 'sticky_bottom_right');
        $icon_size = get_option('desktop_icon_size', '30');
    }

    if (is_single() && ($enable_mobile_sharing || !$is_mobile)) {
        $post_url = urlencode(get_permalink());
        $post_title = urlencode(get_the_title());

        $social_buttons = '<div class="social-sharing ' . esc_attr($placement) . '" style="z-index:999; align-items:center;">';

        if (get_option('facebook_enabled', true)) {
            $social_buttons .= '<a href="' . esc_url("https://www.facebook.com/sharer/sharer.php?u=$post_url") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($icon_size) . 'px;">' .
                '<i class="fab fa-facebook" style="font-size: ' . esc_attr($icon_size) . 'px; color: #1778f2;"></i>' .
                '</a>';
        }

        if (get_option('twitter_enabled', true)) {
    $social_buttons .= '<a href="' . esc_url("https://twitter.com/intent/tweet?url=$post_url&text=$post_title") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($twitter_size) . 'px;">' .
        '<i class="fab fa-twitter" style="font-size: ' . esc_attr($icon_size) . 'px; color: #1da1f2;"></i>' .
        '</a>';
}

        if (get_option('instagram_enabled', true)) {
    $social_buttons .= '<a href="' . esc_url("https://www.instagram.com/?url=$post_url") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($instagram_size) . 'px;">' .
        '<i class="fab fa-instagram" style="font-size: ' . esc_attr($icon_size) . 'px; color: #E1306C;"></i>' .
        '</a>';
}

       if (get_option('whatsapp_enabled', true)) {
    $social_buttons .= '<a href="' . esc_url("https://wa.me/?text=$post_title%20$post_url") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($whatsapp_size) . 'px;">' .
        '<i class="fab fa-whatsapp" style="font-size: ' . esc_attr($icon_size) . 'px; color: #4dc247;"></i>' .
        '</a>';
}

        if (get_option('linkedin_enabled', true)) {
    $social_buttons .= '<a href="' . esc_url("https://www.linkedin.com/shareArticle?url=$post_url&title=$post_title") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($linkedin_size) . 'px;">' .
        '<i class="fab fa-linkedin" style="font-size: ' . esc_attr($icon_size) . 'px; color: #0d66c2;"></i>' .
        '</a>';
}

        if (get_option('pinterest_enabled', true)) {
    $social_buttons .= '<a href="' . esc_url("https://pinterest.com/pin/create/button/?url=$post_url&media=" . urlencode(get_the_post_thumbnail_url()) . "&description=$post_title") . '" target="_blank" rel="nofollow" style="margin:5px; height:' . esc_attr($pinterest_size) . 'px;">' .
        '<i class="fab fa-pinterest" style="font-size: ' . esc_attr($icon_size) . 'px; color: #e60122;"></i>' .
        '</a>';
}

        $social_buttons .= '</div>';

        $content = $social_buttons . $content;
    }
    return $content;
}

add_filter('the_content', 'wpamit_add_social_sharing_buttons');

function add_social_sharing_menu() {
    add_menu_page(
        'Social Sharing Settings',
        'Social Sharing',
        'manage_options',
        'social-sharing-settings',
        'social_sharing_settings_page',
        'dashicons-share',
        30
    );
}

add_action('admin_menu', 'add_social_sharing_menu');

function social_sharing_settings_page() {
    ?>
    <div class="wrap">
        <h2>Social Sharing Settings</h2>
        <form method="post" action="options.php">
            <?php settings_fields('social-sharing-settings-group'); ?>
            <?php do_settings_sections('social-sharing-settings-group'); ?>
            <table class="form-table">
                <tr>
                    <th scope="col">Social Media</th>
                    <th scope="col">Enable/Disable</th>
                </tr>

                <?php
                $social_media = [
                    'facebook' => ['name' => 'Facebook', 'icon' => 'fab fa-facebook',],
                    'twitter' => ['name' => 'Twitter', 'icon' => 'fab fa-twitter'],
                    'instagram' => ['name' => 'Instagram', 'icon' => 'fab fa-instagram'],
                    'whatsapp' => ['name' => 'WhatsApp', 'icon' => 'fab fa-whatsapp'],
                    'linkedin' => ['name' => 'LinkedIn', 'icon' => 'fab fa-linkedin'],
                    'pinterest' => ['name' => 'Pinterest', 'icon' => 'fab fa-pinterest'],
                ];

                foreach ($social_media as $key => $data) :
                ?>
                    <tr>
                        <td>
                            <i class="<?php echo esc_attr($data['icon']); ?>"></i> <?php echo esc_html($data['name']); ?>
                        </td>
                        <td>
                            <label>
                                <input type="checkbox" name="<?php echo esc_attr($key . '_enabled'); ?>" <?php checked(get_option($key . '_enabled'), 'on'); ?> />
                                Enable
                            </label>
                        </td>
                    </tr>
                <?php endforeach; ?>

                <tr>
                    <th scope="row">Icon Sizes (in pixels)</th>
                    <td>
                        <div class="icon-size-fields">
                            <div class="icon-size-field">
                                <label for="desktop_icon_size">Desktop Size:</label>
                                <input type="text" id="desktop_icon_size" name="desktop_icon_size" value="<?php echo esc_attr(get_option('desktop_icon_size', '')); ?>" placeholder="Desktop Size" />
                            </div>
                            <div class="icon-size-field">
                                <label for="mobile_icon_size">Mobile Size:</label>
                                <input type="text" id="mobile_icon_size" name="mobile_icon_size" value="<?php echo esc_attr(get_option('mobile_icon_size', '')); ?>" placeholder="Mobile Size" />
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <th scope="row">Desktop Placement</th>
                    <td>
                        <select name="social_sharing_placement_desktop">
                            <option value="sticky_right" <?php selected(get_option('social_sharing_placement_desktop'), 'sticky_right'); ?>>Sticky Right</option>
                            <option value="sticky_left" <?php selected(get_option('social_sharing_placement_desktop'), 'sticky_left'); ?>>Sticky Left</option>
                            <option value="sticky_bottom" <?php selected(get_option('social_sharing_placement_desktop'), 'sticky_bottom'); ?>>Sticky Bottom</option>
                            <option value="sticky_bottom_left" <?php selected(get_option('social_sharing_placement_desktop'), 'sticky_bottom_left'); ?>>Sticky Bottom Left</option>
                            <option value="sticky_bottom_right" <?php selected(get_option('social_sharing_placement_desktop'), 'sticky_bottom_right'); ?>>Sticky Bottom Right</option>
                            <option value="with_content" <?php selected(get_option('social_sharing_placement_desktop'), 'with_content'); ?>>With Content</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row">Mobile Placement</th>
                    <td>
                        <select name="social_sharing_placement_mobile">
                            <option value="sticky_right" <?php selected(get_option('social_sharing_placement_mobile'), 'sticky_right'); ?>>Sticky Right</option>
                            <option value="sticky_left" <?php selected(get_option('social_sharing_placement_mobile'), 'sticky_left'); ?>>Sticky Left</option>
                            <option value="sticky_bottom" <?php selected(get_option('social_sharing_placement_mobile'), 'sticky_bottom'); ?>>Sticky Bottom</option>
                            <option value="sticky_bottom_left" <?php selected(get_option('social_sharing_placement_mobile'), 'sticky_bottom_left'); ?>>Sticky Bottom Left</option>
                            <option value="sticky_bottom_right" <?php selected(get_option('social_sharing_placement_mobile'), 'sticky_bottom_right'); ?>>Sticky Bottom Right</option>
                            <option value="with_content" <?php selected(get_option('social_sharing_placement_mobile'), 'with_content'); ?>>With Content</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row">Enable Sharing Icons on Mobile</th>
                    <td>
                        <input type="checkbox" name="enable_mobile_sharing" <?php checked(get_option('enable_mobile_sharing'), 'on'); ?> />
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <style>
        .icon-size-fields {
            display: flex;
            flex-direction: column;
        }
        .icon-size-field {
            margin-bottom: 10px;
        }
        .icon-size-field label {
            display: block;
        }
        @media (min-width: 768px) {
            .form-table {
                width: 30%;
            }
			.wrap {
				margin: 30px 20px 0px 30px;
			}
        }
		@media (max-width: 768px) {
			.wrap {
				margin-left:15px;
			}
		}
    </style>
    <?php
}

// Register and initialize settings
function social_sharing_settings_init() {
    $settings = [
        'desktop_icon_size',
        'mobile_icon_size',
        'social_sharing_placement_desktop',
        'social_sharing_placement_mobile',
        'enable_mobile_sharing',
        'facebook_enabled',
        'twitter_enabled',
        'instagram_enabled',
        'whatsapp_enabled',
        'linkedin_enabled',
        'pinterest_enabled',
    ];

    foreach ($settings as $setting) {
        register_setting('social-sharing-settings-group', $setting);
    }
}

add_action('admin_init', 'social_sharing_settings_init');

function add_social_sharing_placement_styles() {
    $enable_mobile_sharing = get_option('enable_mobile_sharing', true);
    $is_mobile = wp_is_mobile();

    if ($is_mobile) {
        $placement = get_option('social_sharing_placement_mobile', 'sticky_left');
    } else {
        $placement = get_option('social_sharing_placement_desktop', 'sticky_left');
    }

    $styles = '';

    switch ($placement) {
        case 'sticky_right':
            $styles .= '
                .social-sharing.sticky_right {
                    position: fixed;
                    top: 50%;
                    right: 0;
                    transform: translateY(-50%);
                    display: flex;
                    flex-direction: column;
                    align-items: flex-end;
                    background: #fff;
                    margin: 10px;
                    padding: 5px 8px;
                    box-shadow: 0px 2px 5px 0px rgba(213,217,217,.5);
                }';
            break;

        case 'sticky_left':
            $styles .= '
                .social-sharing.sticky_left {
                    position: fixed;
                    top: 50%;
                    left: 0;
                    transform: translateY(-50%);
                    display: flex;
                    flex-direction: column;
                    align-items: flex-start;
                    background: #fff;
                    margin: 10px;
                    padding: 5px 8px;
                    box-shadow: 0px 2px 5px 0px rgba(213,217,217,.5);
                }';
            break;

        case 'sticky_bottom':
            $styles .= '
                .social-sharing.sticky_bottom {
                    position: fixed;
                    bottom: 0;
                    left: 50%;
                    transform: translateX(-50%);
                    display: inline-flex;
                    justify-content: center;
                    align-items: center;
                    background: #fff;
                    margin: 10px;
                    padding: 5px 8px;
                    box-shadow: 0px 2px 5px 0px rgba(213,217,217,.5);
                }';
            break;

		case 'sticky_bottom_left':
            $styles .= '
                .social-sharing.sticky_bottom_left {
                    position: fixed;
                    bottom: 0;
                    left: 0;
                    transform: translateY(0%);
                    display: flex;
                    flex-direction: column;
                    justify-content: flex-end;
                    align-items: flex-start;
                    background: #fff;
                    margin: 10px;
                    padding: 5px 8px;
                    box-shadow: 0px 2px 5px 0px rgba(213,217,217,.5);
                }';
            break;

        case 'sticky_bottom_right':
            $styles .= '
                .social-sharing.sticky_bottom_right {
                    position: fixed;
                    bottom: 0;
                    right: 0;
                    transform: translateY(0%);
                    display: flex;
                    flex-direction: column;
                    justify-content: flex-end;
                    align-items: flex-end;
                    background: #fff;
                    margin: 10px;
                    padding: 5px 8px;
                    box-shadow: 0px 2px 5px 0px rgba(213,217,217,.5);
                }';
            break;	
			
        case 'with_content':
            $styles .= '
                .social-sharing.with_content {
                    display: inline-flex;
                    justify-content: center;
                    align-items: center;
                }';
            break;
    }

    echo '<style>' . $styles . '</style>';
}

add_action('wp_head', 'add_social_sharing_placement_styles');

add_action('admin_post_save_social_sharing_settings', 'save_social_sharing_settings');

function save_social_sharing_settings() {

    if (!current_user_can('manage_options')) {
        return;
    }

    if (!isset($_POST['social_sharing_nonce']) || !wp_verify_nonce($_POST['social_sharing_nonce'], 'social_sharing_settings_nonce')) {
        return;
    }

    $options = [
        'facebook_enabled' => 'intval',
        'facebook_size' => 'sanitize_text_field',
        'twitter_enabled' => 'intval',
        'twitter_size' => 'sanitize_text_field',
        'instagram_enabled' => 'intval',
        'instagram_size' => 'sanitize_text_field',
        'whatsapp_enabled' => 'intval',
        'whatsapp_size' => 'sanitize_text_field',
        'pinterest_enabled' => 'intval',
        'pinterest_size' => 'sanitize_text_field',
        'social_sharing_placement_desktop' => 'sanitize_text_field',
        'social_sharing_placement_mobile' => 'sanitize_text_field',
        'enable_mobile_sharing' => 'intval',
    ];

    foreach ($options as $option_name => $sanitize_callback) {
        if (isset($_POST[$option_name])) {
            $option_value = call_user_func($sanitize_callback, $_POST[$option_name]);
            update_option($option_name, $option_value);
        } else {
            
        }
    }

    wp_redirect(admin_url('admin.php?page=social-sharing-settings&status=success'));
    exit;
}